/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import java.lang.reflect.Type;
import java.util.Comparator;
import lib.toma.animations.QuickSort;
import lib.toma.animations.api.IKeyframeProvider;
import lib.toma.animations.api.IKeyframeTypeSerializer;
import lib.toma.animations.api.event.AnimationEventType;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.api.event.IAnimationEventSerializer;
import lib.toma.animations.api.lifecycle.Registries;
import lib.toma.animations.engine.frame.FrameProviderType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class KeyframeProviderSerializer
implements JsonSerializer<IKeyframeProvider>,
JsonDeserializer<IKeyframeProvider> {
    public JsonElement serialize(IKeyframeProvider src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        FrameProviderType<?> type = src.getType();
        IAnimationEvent[] events = src.getEvents();
        object.addProperty("type", type.getKey());
        if (type.areEventsSupported() && events.length > 0) {
            object.add("events", (JsonElement)this.serializeEvents(events, context));
        }
        object.add("data", this.serializeType(type, src, context));
        return object;
    }

    public IKeyframeProvider deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Not a Json object!");
        }
        JsonObject object = json.getAsJsonObject();
        String typeKey = JSONUtils.func_151200_h((JsonObject)object, (String)"type");
        FrameProviderType type = FrameProviderType.getType(typeKey);
        if (type == null) {
            throw new JsonSyntaxException("Unknown frame provider type: " + typeKey);
        }
        IKeyframeTypeSerializer serializer = type.serializer();
        IAnimationEvent[] events = IAnimationEvent.NO_EVENTS;
        if (type.areEventsSupported() && object.has("events")) {
            events = this.deserializeEvents(JSONUtils.func_151214_t((JsonObject)object, (String)"events"), context);
        }
        return serializer.deserialize(JSONUtils.func_152754_s((JsonObject)object, (String)"data"), context, events);
    }

    private <FP extends IKeyframeProvider> JsonElement serializeType(FrameProviderType<FP> type, IKeyframeProvider source, JsonSerializationContext context) {
        IKeyframeTypeSerializer<IKeyframeProvider> serializer = type.serializer();
        JsonObject object = new JsonObject();
        serializer.serialize(object, source, context);
        return object;
    }

    private <E extends IAnimationEvent> IAnimationEvent[] deserializeEvents(JsonArray src, JsonDeserializationContext context) throws JsonParseException {
        IAnimationEvent[] events = new IAnimationEvent[src.size()];
        for (int i = 0; i < src.size(); ++i) {
            JsonElement element = src.get(i);
            if (!element.isJsonObject()) {
                throw new JsonSyntaxException("Not a Json object!");
            }
            JsonObject object = element.getAsJsonObject();
            ResourceLocation typeKey = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"type"));
            AnimationEventType<?> type = Registries.EVENTS.getElement(typeKey);
            if (type == null) {
                throw new JsonSyntaxException("Unknown event type: " + typeKey);
            }
            IAnimationEventSerializer<?> serializer = type.serializer();
            float target = JSONUtils.func_151217_k((JsonObject)object, (String)"target");
            Object event = serializer.deserialize(target, JsonHelper.get(object, "data"), context);
            events[i] = event;
        }
        QuickSort.sort(events, Comparator.comparingDouble(IAnimationEvent::invokeAt));
        return events;
    }

    private <E extends IAnimationEvent> JsonArray serializeEvents(IAnimationEvent[] events, JsonSerializationContext context) {
        JsonArray array = new JsonArray();
        for (IAnimationEvent iAnimationEvent : events) {
            JsonObject object = new JsonObject();
            IAnimationEvent event = iAnimationEvent;
            AnimationEventType<?> type = event.getType();
            IAnimationEventSerializer<?> serializer = type.serializer();
            object.addProperty("type", type.getKey().toString());
            object.addProperty("target", (Number)Float.valueOf(event.invokeAt()));
            object.add("data", serializer.serialize(event, context));
            array.add((JsonElement)object);
        }
        return array;
    }
}

